<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use App\Models\DownloadInfo;

class DownlaodLargeDataset implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $offset;
    protected $perPage;
    protected $id;
    protected $downloadFor;
    protected $currentPage;
    protected $fromDate;
    protected $toDate;
    protected $getAllRegionIDs;

    public function __construct($offset, $perPage, $id, $downloadFor, $currentPage, $fromDate, $toDate, $getAllRegionIDs)
    {
        $this->offset = $offset;
        $this->perPage = $perPage;
        $this->id = $id;
        $this->downloadFor = $downloadFor;
        $this->currentPage = $currentPage;
        $this->fromDate = $fromDate;
        $this->toDate = $toDate;
        $this->getAllRegionIDs = $getAllRegionIDs;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if ($this->downloadFor == 'IC') {
          $this->getICRecords();
        }
    }
    private function getICRecords() {
      $result = DB::table('tbl_farmer as tf')
                    ->leftJoin('tbl_employee as te', 'tf.empId', '=', 'te.id')
                    ->leftJoin('tbl_category as tcc', 'tcc.category_id', '=', 'tf.farmerRegion')
                    ->select('tf.farmerId', 'tf.farmerRegDate', 'tf.farmerName', 'tf.farmerCity', 'tf.farmerWaterDependency', 'tf.farmerRabiCrop1', 'tf.farmerRabiCrop1Acer', 'tf.farmerRabiCrop2', 'tf.farmerRabiCrop2Acer', 'tf.farmerRabiCrop3', 'tf.farmerRabiCrop3Acer', 'tf.farmerKharifCrop1', 'tf.farmerKharifCrop1Acer', 'tf.farmerKharifCrop2', 'tf.farmerKharifCrop2Acer', 'tf.farmerKharifCrop3', 'tf.farmerKharifCrop3Acer',  'tf.farmerLandAcerage', 'tf.farmerMobile', 'tf.farmerAddress', 'te.emp_name', 'tcc.category_name')
                    ->whereIn('tf.farmerRegion', explode(',', $this->getAllRegionIDs))
                    ->whereBetween('tf.farmerRegDate',[$this->fromDate, $this->toDate])
                    ->offset($this->offset)->limit($this->perPage)->get();

      $reportArray = Cache::get('icData');
      foreach ($result as $value) {
         $data['Employee Name'] = $value->emp_name;
         $data['Region Name'] = $value->category_name;
         $data['Farmer Name'] = $value->farmerName;
         $data['Farmer Mobile'] = $value->farmerMobile;
         $data['Farmer Reg Date'] = $value->farmerRegDate;
         $data['farmerLandAcerage'] = $value->farmerLandAcerage;
         $data['Farmer Address'] = $value->farmerAddress;
         $data['Farmer City'] = $value->farmerCity;
         $data['Farmer Water Dependency'] = $value->farmerWaterDependency;
         $data['farmerRabiCrop1'] = $value->farmerRabiCrop1;
         $data['farmerRabiCrop1Acer'] = $value->farmerRabiCrop1Acer;
         $data['farmerRabiCrop2'] = $value->farmerRabiCrop2;
         $data['farmerRabiCrop2Acer'] = $value->farmerRabiCrop2Acer;
         $data['farmerRabiCrop3'] = $value->farmerRabiCrop3;
         $data['farmerRabiCrop3Acer'] = $value->farmerRabiCrop3Acer;
         $data['farmerKharifCrop1'] = $value->farmerKharifCrop1;
         $data['farmerKharifCrop1Acer'] = $value->farmerKharifCrop1Acer;
         $data['farmerKharifCrop2'] = $value->farmerKharifCrop2;
         $data['farmerKharifCrop2Acer'] = $value->farmerKharifCrop2Acer;
         $data['farmerKharifCrop3'] = $value->farmerKharifCrop3;
         $data['farmerKharifCrop3Acer'] = $value->farmerKharifCrop3Acer;

         array_push($reportArray, $data);
      }

      Cache::put('icData', $reportArray);

      $update = DownloadInfo::find($this->id);
      $update->processed_records = $this->currentPage * $this->perPage;

      if ($update->total_pages == $this->currentPage) {
        $update->is_all_record_proceed = true;
      }

      $update->save();

    }
}
