<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Client;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;


class ClientController extends Controller
{
    // store client data
    public function storeClient(Request $request)
    {
        //$license_key = generate_license();

        // Or generate license key with a suffix (numeric, IP, or custom string)
        $license_key_with_suffix = generate_license($request->mobile_no); // or '192.168.1.100' or 'MyCustomSuffix'

        return response()->json([
            'license_key' => $license_key,
            'license_key_with_suffix' => $license_key_with_suffix,
        ]);
        //Validation rules
        $validator = Validator::make($request->all(), [
            'client_name' => 'required|string|max:255',
            'mobile_no' => 'required|digits:10|unique:tbl_clients',
            'contact_person' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'dbname' => 'required|string',
            'lisence_type' => 'required|in:1,2',
            //'lisence_key' => 'required|string|max:255|unique:tbl_clients',
            'registration_date' => 'required|date',
            'expiry_date' => 'required|date|after:registration_date',
            'status' => 'required|in:0,1',
        ]);

        // If validation fails
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ], 400);
        }
        
        // Insert data
        try {
            $client = new Client();
            $client->client_name = $request->client_name;
            $client->mobile_no = $request->mobile_no;
            $client->contact_person = $request->contact_person;
            $client->address = $request->address;
            $client->dbname = $request->dbname;
            $client->lisence_type = $request->lisence_type;
            $client->lisence_key = $license_key_with_suffix;
            $client->registration_date = $request->registration_date;
            $client->expiry_date = $request->expiry_date;
            $client->status = $request->status;

            $client->save();

            //  Now create a new database with the dbname parameter
            $newDatabaseName = $request->dbname;
            DB::statement("CREATE DATABASE IF NOT EXISTS $newDatabaseName");
            $newDatabaseName = 'pos_qispl';
            // Copy tables from `pos_qispl_db` to the new database
            $this->copyTablesToNewDatabase('imconnect_qispl', $newDatabaseName);

            return response()->json([
                'success' => true,
                'message' => 'Client data inserted and new database created successfully!',
                'client' => $client
            ], 200);

        } catch (QueryException $e) {
            // Catch any database-related errors
            return response()->json([
                'success' => false,
                'message' => 'Database error: ' . $e->getMessage()
            ], 500);
        } catch (\Exception $e) {
            // Catch any other errors
            return response()->json([
                'success' => false,
                'message' => 'An error occurred: ' . $e->getMessage()
            ], 500);
        }
    }

    /**
 * Function to copy tables and data from one database to another
 */
private function copyTablesToNewDatabase($sourceDb, $targetDb)
{
    // Step 1: Ensure the target database exists
    DB::connection('mysql')->statement("CREATE DATABASE IF NOT EXISTS `$targetDb`");

    // Step 2: Define a dynamic database connection for the target database
    config([
        'database.connections.targetdb' => [
            'driver'    => 'mysql',
            'host'      => env('DB_HOST', '127.0.0.1'),
            'port'      => env('DB_PORT', '3306'),
            'database'  => $targetDb,
            'username'  => env('DB_USERNAME', 'root'),
            'password'  => env('DB_PASSWORD', ''),
            'charset'   => 'utf8mb4',
            'collation' => 'utf8mb4_unicode_ci',
            'prefix'    => '',
            'strict'    => true,
        ],
    ]);

    $targetConnection = DB::connection('targetdb'); // Connect to the target database

    // Step 3: Get all tables from the source database
    $tables = DB::connection('mysql')->select("SHOW TABLES FROM `$sourceDb`");

    foreach ($tables as $table) {
        // Extract the table name
        $tableName = array_values((array)$table)[0];

        if (!is_string($tableName)) {
            \Log::error("Unexpected table name format, skipping: " . json_encode($table));
            continue;
        }

        // Step 4: Check if the table already exists in the target database
        $tableExists = $targetConnection->select("SHOW TABLES LIKE '$tableName'");

        if (count($tableExists) > 0) {
            \Log::info("Table $tableName already exists in $targetDb, skipping creation.");
        } else {
            // Step 5: Get the CREATE TABLE statement from the source database
            $createTableSQLResult = DB::connection('mysql')->select("SHOW CREATE TABLE `$sourceDb`.`$tableName`");
            \Log::info("CREATE TABLE result for $tableName: " . json_encode($createTableSQLResult));

            $createTableSQL = $createTableSQLResult[0]->{'Create Table'} ?? $createTableSQLResult[0]->{'CREATE TABLE'} ?? null;

            if (empty($createTableSQL)) {
                \Log::error("Failed to retrieve 'CREATE TABLE' SQL for $tableName. Skipping...");
                continue;
            }

            // Step 6: Create the table in the target database
            $targetConnection->statement($createTableSQL);
        }

        // Step 7: Copy data from source table to target table
        $rows = DB::connection('mysql')->table("$sourceDb.$tableName")->get();

        if ($rows->isEmpty()) {
            \Log::info("No data to copy for table $tableName.");
            continue;
        }

        // Step 8: Insert data into the target table
        foreach ($rows as $row) {
            $targetConnection->table($tableName)->insert((array) $row);
        }

        \Log::info("Copied data for table $tableName to $targetDb.");
    }

    \Log::info("All tables from $sourceDb have been copied to $targetDb.");
}


}
